import os

run_id = "160428_SN554_0305_AC91WGACXX"
directory = "/sequencedata/Hiseq2000/%s/Unaligned/" % run_id

filename = "script.sh"
output = open(filename, 'w')

lanes = (2, 3, 4, 5, 6, 7)
barcodes = ("ACAGTG", "ATCACG", "CGATGT", "GCCAAT", "TGACCA", "TTAGGC")
for lane in lanes:
    for barcode in barcodes:
        subdirectory = "Project_LS2744_RNhi10541_Lane%d" % lane
        subsubdirectory = "Sample_RNhi10541"
        library = "RNhi10541_%s_L00%d" % (barcode, lane)
        filename = "%s_R1_001.fastq.gz" % library
        path = os.path.join(directory, subdirectory, subsubdirectory, filename)
        os.symlink(path, filename)
        script_name = "script_%s.sh" % library
        handle = open(script_name, 'w')
        handle.write("""\
#!/bin/bash
#$ -cwd
#$ -e ./script_%s.stderr
#$ -o ./script_%s.stdout
#$ -v PYTHONPATH=/home/mdehoon/lib/python2.7/site-packages,LANG=en_US
#$ -l mem_free=16G
#$ -l h_vmem=16G
/home/mdehoon/bin/tagdust -t8 -arch tagdust.arch -o %s %s
""" % (library, library, library, filename))
        handle.close()
        output.write('qsub -r n %s\n' % script_name)
output.close()
print("Scripts generated; run script.sh to schedule them on Grid Engine")
